//
//  MCPGDatabaseUpdater.h
//  MCPostgresPersistence
//
//  Created by Sebastien Boisvert on 17/09/2009.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCFoundation/MCFoundationDefines.h>
#import <MCFoundation/NSError+MCAdditions.h>
#import <MCFoundation/MCPObjectContext.h>

#import "MCPGServer.h"
#import "MCPPostgresConnection.h"
#import "MCPGSchemaManager.h"
#import "MCPGDatabaseUpdateProgressProtocol.h"

extern NSString* MCPGDatabaseUpdaterDomain;
extern NSString* MCPGDatabaseUpdaterErrorKey;


typedef enum {
	MCPGUpdateStatusContinue = 0,
	MCPGUpdateStatusFail,
	MCPGUpdateStatusQuit, 
	MCPGUpdateStatusRecreate
} MCPGUpdateReturnStatus;

@interface MCPGDatabaseUpdater : NSObject {
	
	MCPGDatabase *database;
	MCPObjectContext *objectContext;
	MCPGSchemaManager *schemaManager;
	NSObject <MCPGDatabaseUpdateProgressProtocol> *progressDelegate;
}

@property (assign) MCPGDatabase *database;
@property (retain) MCPObjectContext *objectContext;
@property (retain) MCPGSchemaManager *schemaManager;
@property (assign) NSObject <MCPGDatabaseUpdateProgressProtocol> *progressDelegate;

-(id)initWithDatabase:(MCPGDatabase**)database error:(NSError **)error ;
-(id)updaterObjectContext;
-(NSError *)updateDatabase;
-(NSError *)applyObjCCommandsForSchema:(NSDictionary *)schema;
-(NSError *)applySQLCommandsForSchema:(NSDictionary *)schema;

-(BOOL)executeDBUpdateScript:(NSString *)script error:(NSError **)error;

@end

